//********************************************************************
//  LargestCircle.java       Author: Lewis and Loftus
//
//  Solution to Programming Project 5.30 (5E, p. 289)
//********************************************************************

import javax.swing.JApplet;
import java.awt.*;
import java.util.Random;

public class LargestCircle extends JApplet
{
   private final int NUM_CIRCLES = 10;
   private final int MIN_DIAMETER = 5;
   private final int MAX_DIAMETER = 30;
   private final int MAX_X = 370;
   private final int MAX_Y = 170;

   private Random rand = new Random();

   //-----------------------------------------------------------------
   //  Paints several circles, with the largest one filled in red.
   //-----------------------------------------------------------------
   public void paint (Graphics page)
   {
      int x, y, diameter, bigX = 0, bigY = 0, bigDiameter = 0;

      setBackground (Color.black);
      page.setColor (Color.white);

      for (int count=1; count <= NUM_CIRCLES; count++)
      {
         x = Math.abs(rand.nextInt()) % MAX_X;
         y = Math.abs(rand.nextInt()) % MAX_Y;
         diameter = Math.abs(rand.nextInt()) % MAX_DIAMETER +
                    MIN_DIAMETER;

         page.drawOval (x, y, diameter, diameter);

         // Keep track of the biggest circle
         if (diameter > bigDiameter)
         {
            bigX = x;
            bigY = y;
            bigDiameter = diameter;
         }
      }

      // Redraw the biggest circle in red
      page.setColor (Color.red);
      page.fillOval (bigX, bigY, bigDiameter, bigDiameter);
   }
}
